' Ten kod pochodzi z ksiki "ASP.NET 2.0. Gotowe rozwizania" autorstwa
' Imara Spaanjaarsa, Paula Wiltona and Shawna Livermore, wydanej przez Wrox.
' Polska edycja: Wydawnictwo Helion.
' Copyright 2006 by Wiley Publishing Inc.
' Informacja o tej ksice jest dostpna na stronie www.wrox.com.  
' Odwied p2p.wrox.com aby podyskutowa o tym kodzie na forach Wrox.

''' <summary>
''' Klasa BookingObject reprezentuje jednostke, ktra moe by wynajta za pomoc Systemu Rezerwacji On-line.
''' Aby uczyni aplikacj elasryczn, zostaa wybrana oglna nazwa, zamiast czego doslownego w rodzaju
''' "fryzjer" czy "sala konferencyjna". Konfiguracja aplikacji pozwala administratorowi zdefiniowa
''' przyjazn uytkownikowi nazw obiektu rezerwacji.
''' </summary>
Public Class BookingObject

#Region "Zmienne prywatne"

  Private _Id As Integer = -1
  Private _Title As String = String.Empty
  Private _StartTime As Integer = -1
  Private _EndTime As Integer = -1
  Private _AvailableOnWeekdays As Weekdays

#End Region

#Region "Waciwoci publiczne"

  ''' <summary>
  ''' Pobiera lub ustawia identyfikator obiektu rezerwacji w bazie danych.
  ''' </summary>
  ''' <returns>An Integer zawierajcy identyfikator obiektu rezerwacji w bazie danych jeli obiekt rezerwacji zosta zapisany lub -1 dla nowego i niezapisanego obiektu rezerwacji.</returns>
  Public Property Id() As Integer
    Get
      Return _Id
    End Get
    Set(ByVal value As Integer)
      _Id = value
    End Set
  End Property

  ''' <summary>
  ''' Pobiera lub ustawia kttk nazw / opis obiektu rezerwacji w rodzaju "Sala konferencyjna nr 2"
  ''' </summary>
  Public Property Title() As String
    Get
      Return _Title
    End Get
    Set(ByVal value As String)
      ' upewnij si, e nie zapisujemy wartoci wikszej ni baza danych moe pomieci 
      If value.Length > 100 Then
        value = value.Substring(0, 100)
      End If
      _Title = value
    End Set
  End Property

  ''' <summary>
  ''' Pobiera lub ustawia pierwsz godzin dnia, w ktrej ten obiekt rezerwacji jest dostpny.
  ''' </summary>
  Public Property StartTime() As Integer
    Get
      Return _StartTime
    End Get
    Set(ByVal value As Integer)
      If value < 0 Then
        Throw New ArgumentException("StartTime nie moe by mniejsze ni zero.")
      End If
      _StartTime = value
    End Set
  End Property

  ''' <summary>
  ''' Pobiera lub ustawia ostani godzin dnia, w ktrej ten obiekt rezerwacji jest dostpny.
  ''' </summary>
  Public Property EndTime() As Integer
    Get
      Return _EndTime
    End Get
    Set(ByVal value As Integer)
      If value > 23 Then
        Throw New ArgumentException("EndTime nie moe by wiksze ni 23.")
      End If
      _EndTime = value
    End Set
  End Property

  ''' <summary>
  ''' Pobiera lub ustawia wyliczenie typu Weekdays przechowujce dni tygodnia, w ktrych mona rezerwowa dany obiekt.
  ''' </summary>
  ''' <remarks><example>Aby przechowa wiele dni, uyj operatora Or, na przykad tak: <br /><code>Weekdays.Sunday Or Weekdays.Monday</code></example></remarks>
  Public Property AvailableOnWeekdays() As Weekdays
    Get
      Return _AvailableOnWeekdays
    End Get
    Set(ByVal value As Weekdays)
      _AvailableOnWeekdays = value
    End Set
  End Property

#End Region

End Class

